import pickle
import numpy as np
import random
from inspect import getmembers, isfunction
import symmetries


functions_list = [o for o in getmembers(symmetries) if isfunction(o[1]) and o[0] != "mod12Same"]
functions_name_list = [o[0] for o in getmembers(symmetries) if isfunction(o[1]) and o[0] != "mod12Same"]

folder = "pickles"


def concat(xss):
    new = []
    for xs in xss:
        new.extend(xs)
    return new
        
data_z = concat(pickle.load(open(folder + "/meas16.pcl", "rb")))
print(len(data_z))
print(data_z[0])
data_x = pickle.load(open(folder + "/analyzedmagents2.pcl", "rb"))
print(len(data_x))
assert(len(data_z) == len(data_x))
#data_z.append(pickle.load(open("")))
print(len(data_z))
print(len(data_x))

pairs_0 = [random.choice(range(3, len(data_x) - 4)) for i in  range(80000)]
pairs_1 = [i + random.randint(-3,3) for i in pairs_0]

all_magents = []
all_rels = []
for z in range(len(pairs_0)):
    try:
        all_magents.append(np.reshape(np.concatenate([data_x[pairs_0[z]][0,:], data_x[pairs_1[z]][0,:]]), (512)))
        human = (data_z[pairs_0[z]], data_z[pairs_1[z]])
        rels = np.zeros(len(functions_name_list))

        for (ind, (func_name, func)) in enumerate(functions_list):
            if func(human[0], human[1]):
                rels[ind] = 1
        all_rels.append(rels)
        print(z)
    except:
        print("fail")

#inds = list(range(80000))
#inds.sort(reverse = True, key = lambda i: sum(all_rels[i]))
#print([sum(all_rels[i]) for i in inds[2000:2010]])
#print([sum(all_rels[i]) for i in inds[60000:61000]])
#inds = inds[:61000] + inds[-1000:]
inds = list(range(len(all_rels)))
random.shuffle(inds)
all_magents = [all_magents[ind] for ind in inds]
all_rels = [all_rels[ind] for ind in inds]

pickle.dump((all_magents, all_rels), open(folder + "/reldata.pcl", "wb"))
